/*
 * Fecha 06/07/2010
 */
 
package com.ejie.p06b.servlet.DEC;

import java.util.ArrayList;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejie.p06b.datatype.logic.P06BDECModelos;
import com.ejie.p06b.datatype.logic.P06BDECModelos12jun2010;
import com.ejie.p06b.datatype.model.P06B32T00Datatype;
import com.ejie.p06b.datatype.model.P06B33T00Datatype;
import com.ejie.p06b.datatype.model.P06B34T00Datatype;
import com.ejie.p06b.datatype.model.P06B35T00Datatype;
import com.ejie.p06b.datatype.model.P06B36T00Datatype;
import com.ejie.p06b.datatype.model.P06B37T00Datatype;
import com.ejie.p06b.datatype.model.P06B38T00Datatype;
import com.ejie.p06b.datatype.model.P06B39T00Datatype;
import com.ejie.p06b.datatype.model.P06B40T00Datatype;
import com.ejie.p06b.datatype.model.P06B42T00Datatype;
import com.ejie.p06b.datatype.model.P06B43T00Datatype;
import com.ejie.p06b.datatype.model.P06B44T00Datatype;
import com.ejie.p06b.datatype.model.P06B46T00Datatype;
import com.ejie.p06b.datatype.model.P06B47T00Datatype;
import com.ejie.p06b.datatype.model.P06B48T00Datatype;
import com.ejie.p06b.datatype.model.P06B49T00Datatype;
import com.ejie.p06b.datatype.model.P06B50T00Datatype;
import com.ejie.p06b.datatype.model.P06B51T00Datatype;
import com.ejie.p06b.datatype.model.P06B52T00Datatype;
import com.ejie.p06b.datatype.model.P06B53T00Datatype;
import com.ejie.p06b.dec.P06BCalcTotDEC;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.servlet.P06BServletGenerico;
import com.ejie.p06b.util.P06BFecha;

/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BSeguimientoServlet extends P06BServletGenerico 
{

	//Cambia de idioma en la sesin -> Perfil
	public void ejecutar(HttpServletRequest request, HttpServletResponse response) {
		try {
			//Obtengo los valores de la BD y los meto en la request
			
			//Si se trata de un ejercicio anterior al 2011, coger los datos y mostrarlos como se hace hasta ahora 25/01/2012
			//Si se trata del ejercicio 2011 o posteriores, es decir, del nuevo decreto de 12 junio de 2010, coger y mostrar los nuevos datos
			String ejer = request.getParameter("ejercicioSeguimiento");
//			String ejer = (request.getParameter("ejercicioSeguimiento")==null)?"":request.getParameter("ejercicioSeguimiento");
			if(Integer.parseInt(ejer) < 2011){
				this.obtener(request,response);
				//Redireccionamos a la pgina de Mostrar datos de la DEC
				forward (request, response, P06BPaginas.P06B_JSP_DEC_MOSTRAR);
			}else{
				this.obtenerDecreto12jun2010(request,response);
				//Redireccionamos a la pgina de Mostrar datos de la DEC
				forward (request, response, P06BPaginas.P06B_JSP_DEC_MOSTRAR_DECR12JUN2010);
			}
		}catch (Exception e){
	      	manejarErrores (request, response, e);
	        return;
	    }
	}
		
	
	//Obtengo los datos de la DEC de la B.D. y lo meto en la request. PARA EJERCICIOS ANTERIORES AL 2011
	private boolean obtener(HttpServletRequest request, HttpServletResponse response) throws Exception {
		boolean retorno = true;
		P06BDECModelos objDECModelos = new P06BDECModelos();
		if(request.getParameter("Expedi")!=null && !request.getParameter("Expedi").trim().equals("")
				&& request.getParameter("ejercicioSeguimiento")!=null && !request.getParameter("ejercicioSeguimiento").trim().equals("")){
			P06B32T00Datatype mod01y02 = P06BCorredoresManager.getInstance().selectMod01y02DEC(request.getParameter("Expedi"), request.getParameter("ejercicioSeguimiento"));
			objDECModelos.setMod01y02(mod01y02);
			if(mod01y02==null){
				mod01y02 = new P06B32T00Datatype();
				mod01y02.setNumExp(request.getParameter("Expedi"));
				mod01y02.setEjercicio(request.getParameter("ejercicioSeguimiento"));
				retorno = false;
			}else{
				//Ojo con los Double, Cambio los puntos por comas
				mod01y02.setCapSoc(mod01y02.getCapSoc().replaceAll("\\.",","));
				mod01y02.setGarantiaPoliza(mod01y02.getGarantiaPoliza().replaceAll("\\.",","));
				mod01y02.setImporteAval(mod01y02.getImporteAval().replaceAll("\\.",","));
				
				//Cambio las fecha en caso de que sea euskera el idioma
				String idioma = this.getIdioma(request, response);
				if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
					mod01y02.setFecDec(P06BFecha.fechaEuFromFecha(mod01y02.getFecDec()));
					mod01y02.setFecEnvio(P06BFecha.fechaEuFromFecha(mod01y02.getFecEnvio()));
				}
				
				//Obtener la lista de los socios de la DEC
				objDECModelos.setListaMod02Socios(P06BCorredoresManager.getInstance().selectMod02SociosDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
								
				//Obtener la lista de los cargos de administradores y direccin
				objDECModelos.setListaMod02Cargos(P06BCorredoresManager.getInstance().selectMod02CargosDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
				
				//Obtener del Modelo 1 los datos de las sedes
				objDECModelos.setMod1Sedes(P06BCorredoresManager.getInstance().selectMod1SedesDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
				
				//Obtener del Modelo 1 la lista de los medios personales
				objDECModelos.setListaMod1MedPer(P06BCorredoresManager.getInstance().selectMod1MedPerDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
				
				//Obtener los datos del Modelo 2.1
				objDECModelos.setMod21(P06BCorredoresManager.getInstance().selectMod21DEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
				
				//Obtener la lista de Ramos No Vida del Modelo 2.2
				objDECModelos.setListaMod22(P06BCorredoresManager.getInstance().selectMod22DEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
				
				//Obtener los datos del Modelo 2.3
				objDECModelos.setMod23(P06BCorredoresManager.getInstance().selectMod23DEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
				
				//Obtener los datos del Modelo 3
				objDECModelos.setMod3(P06BCorredoresManager.getInstance().selectMod3DEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
				
				//Obtener los justificantes adjuntos
				objDECModelos.setJustifAdjuntos(P06BCorredoresManager.getInstance().selectJustifAdjuntosDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
				
				
				//----Formatear los DOUBLE cambiando los puntos por comas. Formatear las FECHAS si el idioma es euskera.
						
				//Formatear campos del Modelo 0.2 Socios.
				P06B33T00Datatype mod02Socio = null;
				for(int i=0;i<objDECModelos.getListaMod02Socios().size();i++){
					mod02Socio = (P06B33T00Datatype)objDECModelos.getListaMod02Socios().get(i);
					mod02Socio.setParticipa(mod02Socio.getParticipa().replaceAll("\\.",","));
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						mod02Socio.setFecAlta(P06BFecha.fechaEuFromFecha(mod02Socio.getFecAlta()));
					}
				}
				
				//Formatear campos del Modelo 0.2 Cargos
				P06B34T00Datatype mod02Cargo = null;
				for(int i=0;i<objDECModelos.getListaMod02Cargos().size();i++){
					mod02Cargo = (P06B34T00Datatype)objDECModelos.getListaMod02Cargos().get(i);
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						mod02Cargo.setFechNom(P06BFecha.fechaEuFromFecha(mod02Cargo.getFechNom()));
					}
				}
				
				//Formatear campos del Modelo 1 Sedes
				P06B35T00Datatype mod1Sedes = objDECModelos.getMod1Sedes();
				if(mod1Sedes != null){
					mod1Sedes.setPrimasSucur(mod1Sedes.getPrimasSucur().replaceAll("\\.",","));
				}
								
				//Formatear campos del Modelo 1 Medios Personales
				P06B36T00Datatype mod1MedPer = null;
				for(int i=0;i<objDECModelos.getListaMod1MedPer().size();i++){
					mod1MedPer = (P06B36T00Datatype)objDECModelos.getListaMod1MedPer().get(i);
					mod1MedPer.setHoras(mod1MedPer.getHoras().replaceAll("\\.",","));
					mod1MedPer.setGasto(mod1MedPer.getGasto().replaceAll("\\.",","));
				}
				
				//Formatear campos del Modelo 2.1
				P06B37T00Datatype mod21 = objDECModelos.getMod21();
				if(mod21 != null){
					mod21.setVolTotExtAux(mod21.getVolTotExtAux().replaceAll("\\.",","));
					mod21.setVolTotExtOtros(mod21.getVolTotExtOtros().replaceAll("\\.",","));
					mod21.setVolTotPrimCobr(mod21.getVolTotPrimCobr().replaceAll("\\.",","));
					mod21.setNuevaExtAux(mod21.getNuevaExtAux().replaceAll("\\.",","));
					mod21.setNuevaExtOtros(mod21.getNuevaExtOtros().replaceAll("\\.",","));
					mod21.setNuevaPrimCobr(mod21.getNuevaPrimCobr().replaceAll("\\.",","));
				}
				
				//Formatear campos del Modelo 2.2
				P06B38T00Datatype mod22 = null;
				for(int i=0;i<objDECModelos.getListaMod22().size();i++){
					mod22 = (P06B38T00Datatype)objDECModelos.getListaMod22().get(i);
					mod22.setVolTotPrimInter(mod22.getVolTotPrimInter().replaceAll("\\.",","));
					mod22.setVolTotComisDeven(mod22.getVolTotComisDeven().replaceAll("\\.",","));
					mod22.setVolTotHonorProf(mod22.getVolTotHonorProf().replaceAll("\\.",","));
					mod22.setNuevaPrimInter(mod22.getNuevaPrimInter().replaceAll("\\.",","));
					mod22.setNuevaComisDeven(mod22.getNuevaComisDeven().replaceAll("\\.",","));
					mod22.setNuevaHonorProf(mod22.getNuevaHonorProf().replaceAll("\\.",","));
				}
								
				//Formatear campos del Modelo 2.3
				P06B39T00Datatype mod23 = objDECModelos.getMod23();
				if(mod23 != null){
					mod23.setVolTotIndPrimInter(mod23.getVolTotIndPrimInter().replaceAll("\\.",","));
					mod23.setVolTotIndComisDeven(mod23.getVolTotIndComisDeven().replaceAll("\\.",","));
					mod23.setVolTotIndHonorProf(mod23.getVolTotIndHonorProf().replaceAll("\\.",","));
					mod23.setVolTotColPrimInter(mod23.getVolTotColPrimInter().replaceAll("\\.",","));
					mod23.setVolTotColComisDeven(mod23.getVolTotColComisDeven().replaceAll("\\.",","));
					mod23.setVolTotColHonorProf(mod23.getVolTotColHonorProf().replaceAll("\\.",","));
					mod23.setNuevaIndPrimInter(mod23.getNuevaIndPrimInter().replaceAll("\\.",","));
					mod23.setNuevaIndComisDeven(mod23.getNuevaIndComisDeven().replaceAll("\\.",","));
					mod23.setNuevaIndHonorProf(mod23.getNuevaIndHonorProf().replaceAll("\\.",","));
					mod23.setNuevaColPrimInter(mod23.getNuevaColPrimInter().replaceAll("\\.",","));
					mod23.setNuevaColComisDeven(mod23.getNuevaColComisDeven().replaceAll("\\.",","));
					mod23.setNuevaColHonorProf(mod23.getNuevaColHonorProf().replaceAll("\\.",","));
				}
				
				//Formatear campos del Modelo 3
				P06B40T00Datatype mod3 = objDECModelos.getMod3();
				if(mod3 != null){
					mod3.setValorAnadComis(mod3.getValorAnadComis().replaceAll("\\.",","));
					mod3.setValorAnadSubv(mod3.getValorAnadSubv().replaceAll("\\.",","));
					mod3.setValorAnadOtrosIng(mod3.getValorAnadOtrosIng().replaceAll("\\.",","));
					mod3.setValorAnadCompras(mod3.getValorAnadCompras().replaceAll("\\.",","));
					mod3.setValorAnadServExt(mod3.getValorAnadServExt().replaceAll("\\.",","));
					mod3.setValorAnadOtrosTrib(mod3.getValorAnadOtrosTrib().replaceAll("\\.",","));
					mod3.setInverBruta(mod3.getInverBruta().replaceAll("\\.",","));
					mod3.setIngrComisEnt(mod3.getIngrComisEnt().replaceAll("\\.",","));
					mod3.setIngrComisOtros(mod3.getIngrComisOtros().replaceAll("\\.",","));
					mod3.setIngrHonorProf(mod3.getIngrHonorProf().replaceAll("\\.",","));
					mod3.setIngrFinanc(mod3.getIngrFinanc().replaceAll("\\.",","));
					mod3.setGastCostesPer(mod3.getGastCostesPer().replaceAll("\\.",","));
					mod3.setGastComisAuxExt(mod3.getGastComisAuxExt().replaceAll("\\.",","));
					mod3.setGastComisOtros(mod3.getGastComisOtros().replaceAll("\\.",","));
					mod3.setGastFormacion(mod3.getGastFormacion().replaceAll("\\.",","));
					mod3.setGastOtros(mod3.getGastOtros().replaceAll("\\.",","));
					mod3.setCtaActIngr(mod3.getCtaActIngr().replaceAll("\\.",","));
					mod3.setCtaActGast(mod3.getCtaActGast().replaceAll("\\.",","));
					mod3.setCtaOtrasIngr(mod3.getCtaOtrasIngr().replaceAll("\\.",","));
					mod3.setCtaOtrasGast(mod3.getCtaOtrasGast().replaceAll("\\.",","));
				}
				
				//Formatear campos de los justificantes adjuntos a la DEC
				P06B42T00Datatype justifAdjuntoDEC = null;
				for(int i=0;i<objDECModelos.getJustifAdjuntos().size();i++){
					justifAdjuntoDEC = (P06B42T00Datatype)objDECModelos.getJustifAdjuntos().get(i);
					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
						justifAdjuntoDEC.setFecha(P06BFecha.fechaEuFromFecha(justifAdjuntoDEC.getFecha()));
					}
				}

			}	 
			request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"DECModelos",objDECModelos);
		}else{
			retorno = false;
		}
		return retorno;
	}
	
	
	//Obtengo los datos de la DEC de la B.D. y lo meto en la request. PARA EL EJERCICIO 2011 Y POSTERIORES.
	private boolean obtenerDecreto12jun2010(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String ejer = request.getParameter("ejercicioSeguimiento");
		String tipoMediador = request.getParameter("tipoMediador");
		String pestana = request.getParameter("pestana");
		boolean retorno = true;
		P06BDECModelos12jun2010 objDECModelos = new P06BDECModelos12jun2010();
		objDECModelos.setPrevioAlSeguimiento(false);
		P06B32T00Datatype mod01y02 = new P06B32T00Datatype();
		mod01y02.setClase(tipoMediador);
		mod01y02.setNumExp(tipoMediador);
		mod01y02.setEjercicio(ejer);
		objDECModelos.setMod01y02(mod01y02);
		//Ojo con los Double, Cambio los puntos por comas
		mod01y02.setCapSoc(mod01y02.getCapSoc().replaceAll("\\.",","));
		mod01y02.setGarantiaPoliza(mod01y02.getGarantiaPoliza().replaceAll("\\.",","));
		mod01y02.setImporteAval(mod01y02.getImporteAval().replaceAll("\\.",","));
		
		//Cambio las fecha en caso de que sea euskera el idioma
		String idioma = this.getIdioma(request, response);
		if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
			mod01y02.setFecDec(P06BFecha.fechaEuFromFecha(mod01y02.getFecDec()));
			mod01y02.setFecEnvio(P06BFecha.fechaEuFromFecha(mod01y02.getFecEnvio()));
			mod01y02.setFhEfectoDesde(P06BFecha.fechaEuFromFecha(mod01y02.getFhEfectoDesde()));
			mod01y02.setFhEfectoHasta(P06BFecha.fechaEuFromFecha(mod01y02.getFhEfectoHasta()));
		}
		
		//Obtener del Modelo 1 la lista de los medios personales
//		objDECModelos.setListaMod1MedPer(P06BCorredoresManager.getInstance().selectMod1MedPerDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
		if (tipoMediador.equals(P06BConstantes.P06B_CORREDORES_TIPOPER_TODAS)){
			objDECModelos.setListaMod1MedPer(P06BCorredoresManager.getInstance().selectMod1MedPerSeguimiento2(ejer));
		}
		else{
			objDECModelos.setListaMod1MedPer(P06BCorredoresManager.getInstance().selectMod1MedPerSeguimiento(ejer, tipoMediador));
		}
		
		//Obtener la lista de Ramos No Vida del Modelo 2.2
//		objDECModelos.setListaMod22(P06BCorredoresManager.getInstance().selectMod22DEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
		if (tipoMediador.equals(P06BConstantes.P06B_CORREDORES_TIPOPER_TODAS)){
			objDECModelos.setListaMod22(P06BCorredoresManager.getInstance().selectMod22Seguimiento2(ejer));
		}
		else{
			objDECModelos.setListaMod22(P06BCorredoresManager.getInstance().selectMod22Seguimiento(ejer, tipoMediador));
		}
		
		//Obtener los datos del Modelo 33 Activo.
//		objDECModelos.setObj51Mod33Activo(P06BCorredoresManager.getInstance().selectMod33ActivoDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
		if (tipoMediador.equals(P06BConstantes.P06B_CORREDORES_TIPOPER_TODAS)){
			objDECModelos.setObj51Mod33Activo(P06BCorredoresManager.getInstance().selectMod33ActivoSeguimiento2(ejer));
		}
		else{
			objDECModelos.setObj51Mod33Activo(P06BCorredoresManager.getInstance().selectMod33ActivoSeguimiento(ejer, tipoMediador));
		}
		
		//Obtener los datos del Modelo 33 Pasivo.
//		objDECModelos.setObj52Mod33Pasivo(P06BCorredoresManager.getInstance().selectMod33PasivoDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
		if (tipoMediador.equals(P06BConstantes.P06B_CORREDORES_TIPOPER_TODAS)){
			objDECModelos.setObj52Mod33Pasivo(P06BCorredoresManager.getInstance().selectMod33PasivoSeguimiento2(ejer));
		}
		else{
			objDECModelos.setObj52Mod33Pasivo(P06BCorredoresManager.getInstance().selectMod33PasivoSeguimiento(ejer, tipoMediador));
		}
		
		//Obtener los datos del Modelo 3 Vinc.
		objDECModelos.setObj53Mod3Vinc(P06BCorredoresManager.getInstance().selectMod3VincDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
		
		//Obtener los datos del Modelo 3. Con el decreto 12 jun 2010 NO se utiliza.
		//objDECModelos.setMod3(P06BCorredoresManager.getInstance().selectMod3DEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
		
		//Obtener los justificantes adjuntos
		objDECModelos.setJustifAdjuntos(P06BCorredoresManager.getInstance().selectJustifAdjuntosDEC(mod01y02.getEjercicio(), mod01y02.getNumExp()));
		
		
		//----Formatear los DOUBLE cambiando los puntos por comas. Formatear las FECHAS si el idioma es euskera.
				
		//Formatear campos del Modelo 1 Medios Personales
		P06B36T00Datatype mod1MedPer = null;
		for(int i=0;i<objDECModelos.getListaMod1MedPer().size();i++){
			mod1MedPer = (P06B36T00Datatype)objDECModelos.getListaMod1MedPer().get(i);
			mod1MedPer.setHoras(mod1MedPer.getHoras().replaceAll("\\.",","));
			mod1MedPer.setGasto(mod1MedPer.getGasto().replaceAll("\\.",","));
		}
		
		//Formatear campos del Modelo 2.2
		P06B38T00Datatype mod22 = null;
		for(int i=0;i<objDECModelos.getListaMod22().size();i++){
			mod22 = (P06B38T00Datatype)objDECModelos.getListaMod22().get(i);
			mod22.setVolTotPrimInter(mod22.getVolTotPrimInter().replaceAll("\\.",","));
			mod22.setVolTotComisDeven(mod22.getVolTotComisDeven().replaceAll("\\.",","));
			mod22.setVolTotHonorProf(mod22.getVolTotHonorProf().replaceAll("\\.",","));
			mod22.setNuevaPrimInter(mod22.getNuevaPrimInter().replaceAll("\\.",","));
			mod22.setNuevaComisDeven(mod22.getNuevaComisDeven().replaceAll("\\.",","));
			mod22.setNuevaHonorProf(mod22.getNuevaHonorProf().replaceAll("\\.",","));
		}
						
		//Formatear campos del Modelo 2.3
		P06B39T00Datatype mod23 = objDECModelos.getMod23();
		if(mod23 != null){
			mod23.setVolTotIndPrimInter(mod23.getVolTotIndPrimInter().replaceAll("\\.",","));
			mod23.setVolTotIndComisDeven(mod23.getVolTotIndComisDeven().replaceAll("\\.",","));
			mod23.setVolTotIndHonorProf(mod23.getVolTotIndHonorProf().replaceAll("\\.",","));
			mod23.setVolTotColPrimInter(mod23.getVolTotColPrimInter().replaceAll("\\.",","));
			mod23.setVolTotColComisDeven(mod23.getVolTotColComisDeven().replaceAll("\\.",","));
			mod23.setVolTotColHonorProf(mod23.getVolTotColHonorProf().replaceAll("\\.",","));
			mod23.setNuevaIndPrimInter(mod23.getNuevaIndPrimInter().replaceAll("\\.",","));
			mod23.setNuevaIndComisDeven(mod23.getNuevaIndComisDeven().replaceAll("\\.",","));
			mod23.setNuevaIndHonorProf(mod23.getNuevaIndHonorProf().replaceAll("\\.",","));
			mod23.setNuevaColPrimInter(mod23.getNuevaColPrimInter().replaceAll("\\.",","));
			mod23.setNuevaColComisDeven(mod23.getNuevaColComisDeven().replaceAll("\\.",","));
			mod23.setNuevaColHonorProf(mod23.getNuevaColHonorProf().replaceAll("\\.",","));
		}

		//Formatear campos del Modelo 3. InverValorAnad.
		P06B48T00Datatype mod3InvValAnad = objDECModelos.getObj48Mod3InverValorAnad();
		if(mod3InvValAnad != null){
			mod3InvValAnad.setValorAnadComis(mod3InvValAnad.getValorAnadComis().replaceAll("\\.",","));
			mod3InvValAnad.setValorAnadSubv(mod3InvValAnad.getValorAnadSubv().replaceAll("\\.",","));
			mod3InvValAnad.setValorAnadOtrosIng(mod3InvValAnad.getValorAnadOtrosIng().replaceAll("\\.",","));
			mod3InvValAnad.setValorAnadCompras(mod3InvValAnad.getValorAnadCompras().replaceAll("\\.",","));
			mod3InvValAnad.setValorAnadServExt(mod3InvValAnad.getValorAnadServExt().replaceAll("\\.",","));
			mod3InvValAnad.setValorAnadOtrosTrib(mod3InvValAnad.getValorAnadOtrosTrib().replaceAll("\\.",","));
			mod3InvValAnad.setInverBruta(mod3InvValAnad.getInverBruta().replaceAll("\\.",","));
		}

		//Formatear campos del Modelo 31.
		P06B49T00Datatype mod31 = objDECModelos.getObj49Mod31();
		if(mod31 != null){
			mod31.setImpNetoAfecComis(mod31.getImpNetoAfecComis().replaceAll("\\.",","));
			mod31.setImpNetoAfecHonor(mod31.getImpNetoAfecHonor().replaceAll("\\.",","));
			mod31.setImpNetoResto(mod31.getImpNetoResto().replaceAll("\\.",","));
			mod31.setIngrOtrosAfec(mod31.getIngrOtrosAfec().replaceAll("\\.",","));
			mod31.setIngrOtrosResto(mod31.getIngrOtrosResto().replaceAll("\\.",","));
			mod31.setGastPerAfec(mod31.getGastPerAfec().replaceAll("\\.",","));
			mod31.setGastPerResto(mod31.getGastPerResto().replaceAll("\\.",","));
			mod31.setGastOtrosAfec(mod31.getGastOtrosAfec().replaceAll("\\.",","));
			mod31.setGastOtrosResto(mod31.getGastOtrosResto().replaceAll("\\.",","));
			mod31.setIngrFinancAfec(mod31.getIngrFinancAfec().replaceAll("\\.",","));
			mod31.setIngrFinancResto(mod31.getIngrFinancResto().replaceAll("\\.",","));
			mod31.setGastFinancAfec(mod31.getGastFinancAfec().replaceAll("\\.",","));
			mod31.setGastFinancResto(mod31.getGastFinancResto().replaceAll("\\.",","));
		}
		
		//Formatear campos del Modelo 32.
		P06B50T00Datatype mod32 = objDECModelos.getObj50Mod32();
		if(mod32 != null){
			mod32.setImpNetoAfecComis(mod32.getImpNetoAfecComis().replaceAll("\\.",","));
			mod32.setImpNetoAfecHonor(mod32.getImpNetoAfecHonor().replaceAll("\\.",","));
			mod32.setImpNetoResto(mod32.getImpNetoResto().replaceAll("\\.",","));
			mod32.setVariacProduc(mod32.getVariacProduc().replaceAll("\\.",","));
			mod32.setTrabAct(mod32.getTrabAct().replaceAll("\\.",","));
			mod32.setAprov(mod32.getAprov().replaceAll("\\.",","));
			mod32.setIngrOtrosAfec(mod32.getIngrOtrosAfec().replaceAll("\\.",","));
			mod32.setIngrOtrosResto(mod32.getIngrOtrosResto().replaceAll("\\.",","));
			mod32.setGastPerAfec(mod32.getGastPerAfec().replaceAll("\\.",","));
			mod32.setGastPerResto(mod32.getGastPerResto().replaceAll("\\.",","));
			mod32.setGastOtrosAfec(mod32.getGastOtrosAfec().replaceAll("\\.",","));
			mod32.setGastOtrosResto(mod32.getGastOtrosResto().replaceAll("\\.",","));
			mod32.setAmort(mod32.getAmort().replaceAll("\\.",","));
			mod32.setImputSubv(mod32.getImputSubv().replaceAll("\\.",","));
			mod32.setExcesoProv(mod32.getExcesoProv().replaceAll("\\.",","));
			mod32.setEnajInmov(mod32.getEnajInmov().replaceAll("\\.",","));
			mod32.setIngrFinanc(mod32.getIngrFinanc().replaceAll("\\.",","));
			mod32.setGastFinanc(mod32.getGastFinanc().replaceAll("\\.",","));
			mod32.setVariacInstrFinanc(mod32.getVariacInstrFinanc().replaceAll("\\.",","));
			mod32.setDiferCambio(mod32.getDiferCambio().replaceAll("\\.",","));
			mod32.setEnajInstrFinanc(mod32.getEnajInstrFinanc().replaceAll("\\.",","));
			mod32.setImpuesBenef(mod32.getImpuesBenef().replaceAll("\\.",","));
		}

		//Formatear campos del Modelo 33 Activo.
		P06B51T00Datatype mod33Act = objDECModelos.getObj51Mod33Activo();
		if(mod33Act != null){
			mod33Act.setNoCorrInmovIntang(mod33Act.getNoCorrInmovIntang().replaceAll("\\.",","));
			mod33Act.setNoCorrInmovMat(mod33Act.getNoCorrInmovMat().replaceAll("\\.",","));
			mod33Act.setNoCorrInverInmob(mod33Act.getNoCorrInverInmob().replaceAll("\\.",","));
			mod33Act.setNoCorrInverEmp(mod33Act.getNoCorrInverEmp().replaceAll("\\.",","));
			mod33Act.setNoCorrInverFinanc(mod33Act.getNoCorrInverFinanc().replaceAll("\\.",","));
			mod33Act.setNoCorrImpuesDif(mod33Act.getNoCorrImpuesDif().replaceAll("\\.",","));
			mod33Act.setCorrNoCorr(mod33Act.getCorrNoCorr().replaceAll("\\.",","));
			mod33Act.setCorrExist(mod33Act.getCorrExist().replaceAll("\\.",","));
			mod33Act.setCorrDeudClientes(mod33Act.getCorrDeudClientes().replaceAll("\\.",","));
			mod33Act.setCorrDeudAccionis(mod33Act.getCorrDeudAccionis().replaceAll("\\.",","));
			mod33Act.setCorrDeudOtros(mod33Act.getCorrDeudOtros().replaceAll("\\.",","));
			mod33Act.setCorrInverEmp(mod33Act.getCorrInverEmp().replaceAll("\\.",","));
			mod33Act.setCorrInverFinanc(mod33Act.getCorrInverFinanc().replaceAll("\\.",","));
			mod33Act.setCorrPeriodif(mod33Act.getCorrPeriodif().replaceAll("\\.",","));
			mod33Act.setCorrEfect(mod33Act.getCorrEfect().replaceAll("\\.",","));
		}
		
		//Formatear campos del Modelo 33 Pasivo.
		P06B52T00Datatype mod33Pas = objDECModelos.getObj52Mod33Pasivo();
		if(mod33Pas != null){
			mod33Pas.setNetoPropCapEscr(mod33Pas.getNetoPropCapEscr().replaceAll("\\.",","));
			mod33Pas.setNetoPropCapNoExig(mod33Pas.getNetoPropCapNoExig().replaceAll("\\.",","));
			mod33Pas.setNetoPropPrimEmis(mod33Pas.getNetoPropPrimEmis().replaceAll("\\.",","));
			mod33Pas.setNetoPropReser(mod33Pas.getNetoPropReser().replaceAll("\\.",","));
			mod33Pas.setNetoPropAccion(mod33Pas.getNetoPropAccion().replaceAll("\\.",","));
			mod33Pas.setNetoPropResEjerAnt(mod33Pas.getNetoPropResEjerAnt().replaceAll("\\.",","));
			mod33Pas.setNetoPropOtrasApor(mod33Pas.getNetoPropOtrasApor().replaceAll("\\.",","));
			mod33Pas.setNetoPropResEjer(mod33Pas.getNetoPropResEjer().replaceAll("\\.",","));
			mod33Pas.setNetoPropDividen(mod33Pas.getNetoPropDividen().replaceAll("\\.",","));
			mod33Pas.setNetoPropOtrosInstr(mod33Pas.getNetoPropOtrosInstr().replaceAll("\\.",","));
			mod33Pas.setNetoAjusCam(mod33Pas.getNetoAjusCam().replaceAll("\\.",","));
			mod33Pas.setNetoSubv(mod33Pas.getNetoSubv().replaceAll("\\.",","));
			mod33Pas.setNoCorrProv(mod33Pas.getNoCorrProv().replaceAll("\\.",","));
			mod33Pas.setNoCorrDeudCred(mod33Pas.getNoCorrDeudCred().replaceAll("\\.",","));
			mod33Pas.setNoCorrDeudArren(mod33Pas.getNoCorrDeudArren().replaceAll("\\.",","));
			mod33Pas.setNoCorrDeudOtras(mod33Pas.getNoCorrDeudOtras().replaceAll("\\.",","));
			mod33Pas.setNoCorrDeudEmp(mod33Pas.getNoCorrDeudEmp().replaceAll("\\.",","));
			mod33Pas.setNoCorrImpuesDif(mod33Pas.getNoCorrImpuesDif().replaceAll("\\.",","));
			mod33Pas.setNoCorrPeriodif(mod33Pas.getNoCorrPeriodif().replaceAll("\\.",","));
			mod33Pas.setCorrNoCorr(mod33Pas.getCorrNoCorr().replaceAll("\\.",","));
			mod33Pas.setCorrProv(mod33Pas.getCorrProv().replaceAll("\\.",","));
			mod33Pas.setCorrDeudCred(mod33Pas.getCorrDeudCred().replaceAll("\\.",","));
			mod33Pas.setCorrDeudArren(mod33Pas.getCorrDeudArren().replaceAll("\\.",","));
			mod33Pas.setCorrDeudOtras(mod33Pas.getCorrDeudOtras().replaceAll("\\.",","));
			mod33Pas.setCorrDeudEmp(mod33Pas.getCorrDeudEmp().replaceAll("\\.",","));
			mod33Pas.setCorrProveed(mod33Pas.getCorrProveed().replaceAll("\\.",","));
			mod33Pas.setCorrOtrosAcreed(mod33Pas.getCorrOtrosAcreed().replaceAll("\\.",","));
			mod33Pas.setCorrPeriodif(mod33Pas.getCorrPeriodif().replaceAll("\\.",","));
		}
		  
		//Formatear campos del Modelo 3 Vinc.
		P06B53T00Datatype mod3Vinc = objDECModelos.getObj53Mod3Vinc();
		if(mod3Vinc != null){
			mod3Vinc.setIngrComis(mod3Vinc.getIngrComis().replaceAll("\\.",","));
			mod3Vinc.setIngrFinanc(mod3Vinc.getIngrFinanc().replaceAll("\\.",","));
			mod3Vinc.setIngrOtros(mod3Vinc.getIngrOtros().replaceAll("\\.",","));
			mod3Vinc.setGastCostesPer(mod3Vinc.getGastCostesPer().replaceAll("\\.",","));
			mod3Vinc.setGastComisAuxExt(mod3Vinc.getGastComisAuxExt().replaceAll("\\.",","));
			mod3Vinc.setGastFormacion(mod3Vinc.getGastFormacion().replaceAll("\\.",","));
			mod3Vinc.setGastFinanc(mod3Vinc.getGastFinanc().replaceAll("\\.",","));
			mod3Vinc.setGastOtros(mod3Vinc.getGastOtros().replaceAll("\\.",","));
			mod3Vinc.setCtaIngrTotal(mod3Vinc.getCtaIngrTotal().replaceAll("\\.",","));
			mod3Vinc.setCtaGastTotal(mod3Vinc.getCtaGastTotal().replaceAll("\\.",","));
		}
		
		//Formatear campos de los justificantes adjuntos a la DEC
		P06B42T00Datatype justifAdjuntoDEC = null;
		for(int i=0;i<objDECModelos.getJustifAdjuntos().size();i++){
			justifAdjuntoDEC = (P06B42T00Datatype)objDECModelos.getJustifAdjuntos().get(i);
			if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
				justifAdjuntoDEC.setFecha(P06BFecha.fechaEuFromFecha(justifAdjuntoDEC.getFecha()));
			}
		}

		objDECModelos.setObjTotales(P06BCalcTotDEC.calcTotalesDEC(objDECModelos));
		
		request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"DECModelos",objDECModelos);
		return retorno;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
}